jQuery(function ($) {
    let otpTimer = null
    // now you can use jQuery code here with $ shortcut formatting
    // this executes immediately - before the page is finished loading
    $("document").ready(function () {
        //   events   //
        $("#login-btn").click(() => {
            login()
        })
        $("#mobile").keydown(({key}) => {
            if (key === 'Enter')
                login()
        })
        $("#pw-login-btn").click(() => {
            verifyPass()
        })
        $("#password").keydown(({key}) => {
            if (key === 'Enter')
                verifyPass()
        })
        $("#otp-inputs").on({
            input: (e) => {
                const target = e.target;
                const val = target.value;

                if (isNaN(val)) {
                    target.value = "";
                    return;
                }

                if (val != "") {
                    const next = target.nextElementSibling;
                    if (next) {
                        next.focus();
                    }
                }
            },
            keyup: (e) => {
                const target = e.target;
                const key = e.key.toLowerCase();

                if (key == "backspace" || key == "delete") {
                    target.value = "";
                    const prev = target.previousElementSibling;
                    if (prev) {
                        prev.focus();
                    }
                    return;
                }
            }
        })
        $(".otp-input:last-child").keydown((e) => {
            if (e.key === 'Enter')
                verifyOtp()
        })
        $("#send-otp-btn").click(() => {
            sendOtp()
        })
        $("#change-mobile-btn").click(() => {
            $("#otp-verify").hide()
            $("#mobile-login").show()
        })
        $("#resend-btn").click(() => {
            sendOtp()
        })
        $("#otp-btn").click(() => {
            verifyOtp()
        })

        //   functions   //
        const validateMobile = (mobile) => {
            const mobileError = $("#mobile-error")
            const regex = /09[0-9][0-9]-?[0-9]{3}-?[0-9]{4}$/

            if (mobile == '') {
                mobileError
                    .text("*وارد کردن این فیلد الزامی است.")
                    .show();
                return false;
            } else if (!regex.test(mobile)) {
                mobileError
                    .text("**شماره موبایل وارد شده صحیح نیست")
                    .show();
                return false;
            }
            mobileError.hide();
            return true;
        }

        const authenticate = async (mobile) => {
            const loginText = $("#login-text")
            const loginBtn = $("#login-btn")
            loginText.addClass("button--loading")
            loginBtn.prop('disabled', true)
            await $.post(ajax_object.ajax_url, {
                action: 'taamito_login',
                mobile: mobile
            })
                .done((data) => {
                    const entity = JSON.parse(data).entity
                    $("#mobile-login").hide()
                    if (entity.is_enable_password)
                        $("#password-verify").show()
                    else {
                        $(".loader").show()
                        sendOtp()
                    }
                })
                .catch((e) => {
                    showError(e.responseJSON.data.error)
                })
            loginText.removeClass("button--loading")
            loginBtn.prop('disabled', false)
        }

        const login = () => {
            const mobile = $("#mobile").val()
            let valid = validateMobile(mobile)
            if (!valid) return
            authenticate(mobile)
        }

        const validatePassword = (password) => {
            const errorPass = $("#password-error")

            if (password == '') {
                errorPass
                    .text("*وارد کردن این فیلد الزامی است.")
                    .show();
                return false;
            }
            errorPass.hide();
            return true;
        }

        const verifyPass = async () => {
            const password = $("#password").val()
            const mobile = $("#mobile").val()
            const button = $("#pw-login-btn")
            const buttonText = $("#pw-login-text")
            const valid = validatePassword(password)
            if (!valid) return

            buttonText.addClass("button--loading")
            button.prop('disabled', true)

            await $.post(ajax_object.ajax_url, {
                action: 'taamito_verify',
                code: password,
                mobile: mobile,
                with_password: 1,
            })
                .done((data) => {
                    location.reload()
                })
                .catch((e) => {
                    showError(e.responseJSON.data.error)
                })

            buttonText.removeClass("button--loading")
            button.prop('disabled', false)
        }

        const sendOtp = async () => {
            const otpButton = $("#send-otp-btn")
            const otpButtonText = $("#send-otp-text")
            const resendButton = $("#resend-btn")
            const resendButtonText = $("#resend-text")
            const mobile = $("#mobile").val()

            $("#otp-mobile").text(mobile)
            resendButtonText.text('2:00')

            otpButtonText.addClass("button--loading")
            otpButton.prop('disabled', true)
            resendButtonText.addClass("button--loading")
            resendButton.prop('disabled', true)

            await $.post(ajax_object.ajax_url, {
                action: 'taamito_send_otp',
                mobile: mobile
            })
                .done((data) => {
                    otpTimer = setInterval(interval, 1000)
                    $(".loader").hide()
                    $("#password-verify").hide()
                    $("#otp-verify").show()
                    resendButtonText.text('2:00')
                    $('#resend-btn')
                        .prop('disabled', true)
                        .addClass('disabled-btn')
                })
                .catch((e) => {
                    $(".loader").hide()
                    $("#mobile-login").show()
                    showError(e.responseJSON.data.error)
                })

            otpButtonText.removeClass("button--loading")
            otpButton.prop('disabled', false)
            resendButtonText.removeClass("button--loading")
            resendButton.prop('disabled', false)
        }

        const interval = (function () {
            const timerBtn = $('#resend-btn')
            const timerText = $("#resend-text")
            let timer2 = timerText.text()
            let timer = timer2.split(':');
            //by parsing integer, I avoid all extra string processing
            let minutes = parseInt(timer[0], 10);
            let seconds = parseInt(timer[1], 10);
            --seconds;
            minutes = (seconds < 0) ? --minutes : minutes;
            seconds = (seconds < 0) ? 59 : seconds;
            seconds = (seconds < 10) ? '0' + seconds : seconds;

            timerText.text(minutes + ':' + seconds);
            timer2 = minutes + ':' + seconds;
            if (minutes < 0) {
                clearInterval(otpTimer);
                timerText.text("ارسال مجدد")
                timerBtn
                    .prop('disabled', false)
                    .removeClass('disabled-btn')
            }
        })

        const validateOtp = (code) => {
            const errorotp = $("#otp-error")

            if (code == '') {
                errorotp
                    .text("*وارد کردن این فیلد الزامی است.")
                    .show();
                return false;
            } else if (code.length < 4) {
                errorotp
                    .text("**کد میبایست چهار رقم باشد")
                    .show();
                return false;
            }
            errorotp.hide()
            return true
        }

        const verifyOtp = async () => {
            const otpText = $("#otp-text")
            const otpButton = $("#otp-btn")
            const inputs = $("#otp-inputs").children()
            let otpCode = ''
            for (const input of inputs) {
                otpCode += input.value
            }
            const valid = validateOtp(otpCode)
            if (!valid) return

            otpText.addClass("button--loading")
            otpButton.prop('disabled', true)

            await $.post(ajax_object.ajax_url, {
                action: 'taamito_verify',
                code: otpCode,
                mobile: $("#mobile").val(),
                with_password: 0,
            })
                .done((data) => {
                    location.reload()
                })
                .catch((e) => {
                    showError(e.responseJSON.data.error)
                })

            otpText.removeClass("button--loading")
            otpButton.prop('disabled', false)
        }

        const showError = (message) => {
            $(".error-box").show()
            $(".error-box-msg").text(message)
            setTimeout(() => {
                $(".error-box").hide()
            }, 4000)
        }
    })
});
