<?php

use Miladmodaresi\Taamito\Base\Api;
use Miladmodaresi\Taamito\Base\Taamito;

if (!function_exists('taamitoApp')) {
    /**
     * @return Taamito
     */
    function taamitoApp()
    {
        return Taamito::getInstance();
    }
}
if (!function_exists('taamitoApi')) {
    /**
     * @return Api
     */
    function taamitoApi()
    {
        return new Api;
    }
}

if ( ! function_exists( 'array_is_list' ) ) {
	/**
	 * Polyfill for `array_is_list()` function added in PHP 8.1.
	 *
	 * Determines if the given array is a list.
	 *
	 * An array is considered a list if its keys consist of consecutive numbers from 0 to count($array)-1.
	 *
	 * @see https://github.com/symfony/polyfill-php81/tree/main
	 *
	 * @since 6.5.0
	 *
	 * @param array<mixed> $arr The array being evaluated.
	 * @return bool True if array is a list, false otherwise.
	 */
	function array_is_list( $arr ) {
		if ( ( array() === $arr ) || ( array_values( $arr ) === $arr ) ) {
			return true;
		}

		$next_key = -1;

		foreach ( $arr as $k => $v ) {
			if ( ++$next_key !== $k ) {
				return false;
			}
		}

		return true;
	}
}

if (!function_exists('taamitoGenerateRandomString')) {

    function taamitoGenerateRandomString($length = 10)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}

if (!function_exists('dd')) {

    function dd()
    {
        krumo(func_get_args());
        exit;
    }
}

if (!function_exists('taamitoNormalizeFields')) {

    /**
     * Normalize Taamito "fields" payloads that might arrive as arrays, objects or JSON strings.
     *
     * @param mixed $fields
     * @return array|null
     */
    function taamitoNormalizeFields($fields)
    {
        if (is_null($fields)) {
            return null;
        }

        if (is_string($fields)) {
            $decoded = json_decode($fields, true);
            return json_last_error() === JSON_ERROR_NONE ? $decoded : null;
        }

        if ($fields instanceof \stdClass) {
            return (array)$fields;
        }

        if (is_array($fields)) {
            return $fields;
        }

        return null;
    }
}

if (!function_exists('taamitoEnsureFieldsOption')) {
    function taamitoEnsureFieldsOption()
    {
        $fields = taamitoApp()->getOption('fields');
        if ($fields === false || $fields === null || $fields === []) {
            $defaultFields = [
                'name' => 2,
                'description' => 2,
                'short_description' => 2,
                'category_ids' => 2,
                'sku' => 2,
                'tags' => 2,
                'images' => 2,
                'thumbnail' => 2,
                'price' => 2,
                'purchase_price' => 2,
                'stock' => 2,
                'weight' => 2,
                'height' => 2,
                'width' => 2,
                'length' => 2,
            ];

            taamitoApp()->saveOption('fields', $defaultFields);
            return $defaultFields;
        }

        return $fields;
    }
}
