<?php

namespace Miladmodaresi\Taamito\Api;

use Miladmodaresi\Taamito\Base\Routes as BaseRoutes;
use Miladmodaresi\Taamito\Middleware\CheckToken;

/**
 * The Singleton class defines the `GetInstance` method that serves as an
 * alternative to constructor and lets clients access the same instance of this
 * class over and over.
 */
class Routes
{
    protected $routes = null;

    function __construct()
    {
        $this->routes = new BaseRoutes;
    }

    public function routes()
    {

        $this->routes->setMiddlewares([CheckToken::class])->post('/categories', [new Category, 'create']);
        $this->routes->setMiddlewares([CheckToken::class])->post('/categories/update', [new Category, 'update']);
        $this->routes->setMiddlewares([CheckToken::class])->post('/categories/delete', [new Category, 'delete']);
        $this->routes->setMiddlewares([CheckToken::class])->post('/products', [new Product, 'create']);
        $this->routes->setMiddlewares([CheckToken::class])->post('/products/update', [new Product, 'update']);
        $this->routes->setMiddlewares([CheckToken::class])->post('/products/delete', [new Product, 'delete']);
        $this->routes->setMiddlewares([CheckToken::class])->get('/products', [new Product, 'get']);
        $this->routes->setMiddlewares([CheckToken::class])->post('/users', [new User, 'create']);
        $this->routes->setMiddlewares([CheckToken::class])->post('/users/update', [new User, 'update']);
        $this->routes->setMiddlewares([CheckToken::class])->post('/users/delete', [new User, 'delete']);
        $this->routes->get('/connection-test', function () {
            return taamitoApp()->view(['is_success' => true]);
        });
    }
}
