<?php

namespace Miladmodaresi\Taamito\Api;

use Miladmodaresi\Taamito\Base\Api;

class ShopApi extends Api
{
    public function createCategory($data)
    {
        $version = time() * 1000;
        return $this->post("shop/categories?Version={$version}", $data);
    }

    public function createFeature($data)
    {
        $version = time() * 1000;
        return $this->post("shop/features?Version={$version}", $data);
    }

    public function createFeatureValue($featureId, $data)
    {
        $version = time() * 1000;
        $url = "shop/features/{$featureId}/values?Version={$version}";
        $fullUrl = $this->baseApi . $this->prefix . $url;
        
        // Make request manually to handle errors gracefully
        $headers = $this->baseHeaders;
        $headers['headers']['Content-Type'] = 'application/json';
        $headers['body'] = json_encode($data);
        
        $response = wp_remote_post($fullUrl, $headers);
        
        $body = wp_remote_retrieve_body($response);
        $code = wp_remote_retrieve_response_code($response);
        $decodedBody = json_decode($body);
        
        // Log for debugging
        \Sentry\captureMessage("Taamito ShopApi createFeatureValue - URL: {$fullUrl}, Code: {$code}, FeatureId: {$featureId}, Response: " . substr($body, 0, 500));
        
        // If error, return error response instead of throwing
        if ($code < 199 || $code >= 300) {
            return $decodedBody; // Return the error response
        }
        
        return $decodedBody;
    }

    public function createProduct($data)
    {
        $version = time() * 1000;
        return $this->post("shop/products/complete?Version={$version}", $data);
    }
}

