<?php

namespace Miladmodaresi\Taamito\Base;

use Exception;

class HttpException extends Exception
{
    protected $data;
    protected $code;
    public function __construct($data, $code)
    {
        $this->data = $data;
        $this->code = $code;
    }
    public function abort()
    {
        \Sentry\captureMessage('HttpException: ' . json_encode($this->data).' Code: '.$this->code);

        if (defined('DOING_AJAX') && DOING_AJAX) {
            return wp_send_json_error($this->data, $this->code);
        }

        $data = '';
        try {
            $data = json_encode($this->data);
        } catch (\Throwable $th) {
            $data = $this->data;
        }
        return throw new Exception($data ? $data : '', $this->code ? $this->code : 500);
    }
}
