<?php

namespace Miladmodaresi\Taamito\Base;

class InitialTaam
{
    public function dbInitialize()
    {
        global $wpdb;
        global $taamDbVersion;

        $tableName = $wpdb->prefix . 'taam_sync';

        $charsetCollate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE  IF NOT EXISTS $tableName (
        `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
        `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
        `local_id` int(11),
        `remote_id` int(11),
        `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        `data` TEXT NULL,
        `status` tinyint(3) UNSIGNED NULL DEFAULT NULL,
        PRIMARY KEY (`id`),
        INDEX `local_id_key`(`local_id`) USING BTREE
        ) $charsetCollate;";
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

        dbDelta($sql);
        add_option('taam_db_version', $taamDbVersion);
    }

    /**
     * Add "Setting" action link to plugins table, left part
     *
     * @return array
     */
    public function plugin_action_links($links)
    {
        $settings_link = '<a href="' . esc_url(admin_url('admin.php?page=taamito_settings')) . '" title="تنظیمات"> 
        تنظیمات
        </a>';

        array_unshift($links, $settings_link);
        return $links;
    } // plugin_action_links

}
