<?php

namespace Miladmodaresi\Taamito\Jobs;

use Miladmodaresi\Taamito\Base\BaseJob;

class VerifyJob implements BaseJob
{
    public $isLogin = false;

    public function __construct()
    {
        $this->process('');
    }

    public function repair()
    {
    }

    public function process($model, $page = 1, $lastSyncAt = null)
    {
        $domain = taamitoApp()->getOption('domain');
        if (!$domain)
            return;
        $response = taamitoApi()->setSubDomain($domain)->get('wp/info');
        
        try {
            $rawFields = ((array)$response->entity)['fields'] ?? null;
            $fields = taamitoNormalizeFields($rawFields);
            if ($fields !== null) {
                taamitoApp()->saveOption('fields', $fields);
            }
            taamitoApp()->saveOption('can_delete', (array)((array)$response->entity)['can_delete']);
            $this->isLogin = true;
        } catch (\Throwable $th) {
            taamitoApp()->deleteOption('user');
            taamitoApp()->deleteOption('token');
        }
    }
}
