<?php

namespace Miladmodaresi\Taamito\Middleware;

use Miladmodaresi\Taamito\Base\HttpException;
use WP_REST_Request;

/**
 * The Singleton class defines the `GetInstance` method that serves as an
 * alternative to constructor and lets clients access the same instance of this
 * class over and over.
 */
class CheckToken
{
    public function handle(WP_REST_Request $request)
    {
        $token = taamitoApp()->getOption('token');
        $requestToken = $request->get_header('token');

        if (!$requestToken || !$token || $requestToken != $token) {
            return (new HttpException(['message' => 'دسترسی غیر مجاز'], 403))->abort();
        }
    }
}
