<?php

namespace Miladmodaresi\Taamito\Services;

use WP_Query;

/**
 * @property WC_Product $productModel
 */
class CategoryService
{

    protected $productModel = null;

    public function create($input, $file)
    {
        $category = wp_insert_term($input['category'], 'product_cat', ['parent' => $input['parent_id']]);
        if (isset($file['logo'])) {
            update_term_meta($category['term_id'], 'thumbnail_id', absint($file));
        }
        return $category;
    }

    public function update($id, $input, $file)
    {
        $category = wp_update_term($id, 'product_cat', ['parent' => $input['parent_id'], 'name' => $input['category']]);
        if (isset($file['logo'])) {
            update_term_meta($category['term_id'], 'thumbnail_id', absint($file));
        }
        return $category;
    }

    public function delete($id)
    {
        $category = wp_delete_term($id, 'product_cat');
        return $category;
    }
}
