<section dir="rtl">
    <div class="container">
        <div class="card-container">

            <div class="info-container">
                <div class="header">
                    <?php echo __('User Information','taamito') ?>
                </div>
                <div class="content">
                    <div>
                        <span class="title"><?php echo __('Full Name','taamito') ?>:</span>
                        <span class="caption">
                            <?php echo ($user["full_name"]); ?>:
                        </span>
                    </div>
                    <div>
                        <span class="title"><?php echo __('mobile','taamito') ?>: </span>
                        <span class="caption">
                            <?php echo ($user["mobile"]); ?>
                        </span>
                    </div>
                </div>

                <div class="divider"></div>

                <div class="header">
                    <?php echo __('Shop Information','taamito') ?>
                </div>
                <div class="content">
                    <div>
                        <span class="title"><?php echo __('Shop Name','taamito') ?>: </span>
                        <span class="caption" dir="ltr">
                            <?php echo __($user["tenants"][0]->name); ?>
                        </span>
                    </div>
                    <div>
                        <span class="title"><?php echo __('Domain Name','taamito') ?>: </span>
                        <span class="caption" dir="ltr">
                            <?php echo __($user["tenants"][0]->domain); ?>
                        </span>
                    </div>
                </div>

                <div class="divider"></div>

                <div class="content">
                    <div>
                        <span class="title">
                            <?php echo __('To sync the data with the platform, set the following code in the control panel of your host','taamito') ?>
                            :
                        </span>
                    </div>
                    <div class="code-container">
                        php -q wp-cron.php >/dev/null 2>&1
                    </div>
                </div>

            </div>

            <?php if (!isset($wizard_completed) || !$wizard_completed): ?>
            <div class="divider"></div>

            <a href="<?php echo admin_url('admin.php?page=taamito_wizard'); ?>">
                <button type="button" class="base-btn primary btn-block">
                    <?php echo __('Data Transfer Wizard','taamito'); ?>
                </button>
            </a>
            <p style="text-align: center; margin-top: 10px; color: #666; font-size: 12px;">
                <?php echo __('Use this wizard to transfer your WordPress data to Taamito for the first time','taamito'); ?>
            </p>
            <?php endif; ?>

            <div class="divider"></div>

            <a href="<?php echo ($user["tenants"][0]->tenant_url); ?>" target="_blank">
                <button type="button" class="base-btn primary btn-block">
                    <?php echo __('Go to Admin Panel','taamito'); ?>
                </button>
            </a>
            <button type="button" id="logout-btn" class="base-btn secondary btn-block">
                <span id="logout-text" class="button__text"><?php echo __('Logout','taamito') ?></span>
            </button>
        </div>
    </div>

</section>